/*
 * QrfeJobDispatcher.h
 *
 *  Created on: 31.01.2011
 *      Author: stefan.detter
 */

#ifndef QRFEJOBDISPATCHER_H_
#define QRFEJOBDISPATCHER_H_

#include <QMap>
#include <QList>
#include <QMutex>
#include <QSemaphore>
#include <QVariant>

typedef struct {
	ulong				jobId;
	QList<QVariant>		params;
} QrfeJobData;

class QrfeJobReceiver
{
public:
	QrfeJobReceiver() {m_componentId = ++m_componentCounter; }

	ulong componentId() const { return m_componentId; }

protected:
	ulong m_componentId;
	static ulong m_componentCounter;
};

class QrfeJobDispatcher : public QObject
{
	Q_OBJECT

public:
	QrfeJobDispatcher();
	virtual ~QrfeJobDispatcher();

	int  jobCount   ( ulong receiver );
	bool waitForJob ( ulong receiver, QrfeJobData& job, ulong maxWaitTime = -1 );
	void removeJobs ( ulong receiver );

	void insertJob ( ulong receiver, ulong jobId, QList<QVariant> params = QList<QVariant>() );
	void insertJob ( QList<ulong> receiver, ulong jobId, QList<QVariant> params = QList<QVariant>() );

signals:
	void jobInserted ( ulong receiver );

private slots:
	void _q_emitSignal ( ulong receiver );

private:
	QMap<ulong, QList<QrfeJobData> >	m_jobData;
	QMutex								m_jobDataMutex;

	QMap<ulong, QSemaphore*>			m_jobNotifier;
	QMutex								m_jobNotifierMutex;
};


#endif /* QRFEJOBDISPATCHER_H_ */
